#ifndef ZMODELER_TMATERIALS_INCLUDED
#define ZMODELER_TMATERIALS_INCLUDED

#include "tTextureSet.h"

/////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////
typedef  struct MATERIALPARAMS
{
  long          PrimTexture;
  long          BumpTexture;
  long          ReflTexture;
  long          RsrvTexture;
  float         Shine;
  D3DTEXTUREOP  PrimApply;
  D3DTEXTUREOP  BumpApply;
  D3DTEXTUREOP  ReflApply;
  D3DTEXTUREOP  RsrvApply;
  D3DBLEND      SrcBlend;
  D3DBLEND      DestBlend;
  BYTE          AlphaTreat; // 0=don't use; 1=blend; 2=test; 3=colorkey
  BYTE          AlphaREF;   //test value; or color key;
  BYTE          AlphaFunc;  //aplha test function; translated to (D3DCMPFUNC)
  BYTE          reserv;
  DWORD         ColorKeyLow;
  DWORD         ColorKeyHigh;
}MATERIALPARAMS, *LPMATERIALPARAMS;

typedef struct D3DMAT
{
  D3DMATERIAL7    MatRec;
  char            MaterialName[MAX_MATERIALNAMELEN];
  MATERIALPARAMS  MatParams;
}D3DMAT, *LPD3DMAT;


class AFX_EXT_CLASS tMaterials
{
public:
  tMaterials();
  ~tMaterials();

  LPD3DMAT        Materials;//set of materials
  long            MaterialsAmount;//amount of materials in Materials array
  tTextureSet     *Textures;//set of textures.

  //Prepares IDirect3DDevice7 to render using specified material.
  void SetCurrentMaterial(
              LPDIRECT3DDEVICE7 pd3dDevice,
              long index,
              DWORD nDeviceFlags,
              DWORD nBlockFlags);
  //creates material.
  long CreateMaterial(
                    LPDIRECT3DDEVICE7 pd3dDevice,
                    float red,
                    float green,
                    float blue,
                    float opacity,
                    float shine,
                    float shinestrength,
                    char* PrimName,
                    char* BumpName,
                    char* ReflName,
                    char* RsrvName,
                    char* matname,
                    DWORD nTexturesFlags,
                    D3DTEXTUREOP PrimA,
                    D3DTEXTUREOP BumpA,
                    D3DTEXTUREOP ReflA,
                    D3DTEXTUREOP RsrvA,
                    D3DBLEND SBlend,
                    D3DBLEND DBlend,
                    BYTE AlphaT,
                    BYTE AlphaREF,
                    BYTE AlphaFunc,
                    DWORD ColorKeyLowValue = 0x00000000,
                    DWORD ColorKeyHighValue = 0x00000000);
  
  void  CleanUpAll();// releases all textures
  void  DeleteAll(); // deletes all materials and releases textures.
  void  DeleteMaterial(long index); //deletes specified material from set.
  char* GetMaterialName(long index);//returns material name.
private:
  void D3D_SimpleInitMaterial(
              D3DMATERIAL7 &m,
              float r,
              float g,
              float b,
              float a,
              float shine,
              float shinestrength);
};

void CALLBACK BackupMaterials(tProcParams* params);

#endif /*ZMODELER_TMATERIALS_INCLUDED*/
